<?

###################################################################################################
# Copyright (c) 2006 Aastra Telecom US, Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#    1. Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#    2. Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#    3. The name of Aastra Telecom US, Inc. may not be used to endorse or promote
#       products derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY AASTRA TELECOM US, INC. ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
# IN NO EVENT SHALL AASTRA TELECOM US, INC. BE LIABLE FOR ANY DIRECT, INDIRECT, 
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
# OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
###################################################################################################
# Asterisk Call Forward for Aastra SIP Phones R1.4.1 or better
#
# php source code
###################################################################################################

include (dirname(__FILE__)."/phpagi/misc.php");
include (dirname(__FILE__)."/phpagi/phpagi-asmanager.php");

###################################################################################################
# Aastra_decode_HTTP_header
#
# Returns an array
#   0 Phone Type
#   1 Phone MAC Address
#   2 Phone firmware version
###################################################################################################

function Aastra_decode_HTTP_header()
{
$user_agent=$_SERVER["HTTP_USER_AGENT"];
if(stristr($user_agent,"Aastra"))
	{
	$value=preg_split("/ MAC:/",$user_agent);
	$fin=preg_split("/ /",$value[1]);
	$value[1]=preg_replace("/\-/","",$fin[0]);
	$value[2]=preg_replace("/V:/","",$fin[1]);
	}
else
	{
	$value[0]="MSIE";
	$value[1]="NA";
	$value[2]="NA";
	}

return($value);
}

###################################################################################################
# Global parameters
$Server = "http://$SERVER_ADDR".$_SERVER['SCRIPT_NAME'];
$cf="";

# Retrieve parameters
$user=$_GET['user'];
$action=$_GET['action'];
$value=$_GET['value'];

# Get header info
$header=Aastra_decode_HTTP_header();

# Connect to AGI
$as = new AGI_AsteriskManager();
$res = $as->connect();

#GET CFWD
$res = $as->Command('database get CF '.$user);
$line=split("\n", $res['data']);
$data=split(" ", $line[0]);
if($data[0]=="Value:") $cf=$data[1];
if($cf=="")
	{
	$data=split(" ", $line[1]);
	if($data[0]=="Value:") $cf=$data[1];
	}

# change CF status
if(isset($action))
	{
	if($action=="cancel")
		{
		$res = $as->Command('database del CF '.$user);
		$output = "<AastraIPPhoneExecute>\n";
		$output .= "<ExecuteItem URI=\"".$Server."?action=msg&amp;user=".$user."\"/>\n";
		switch($header[0])
			{
			case "Aastra9112i":
			case "Aastra9133i":
				break;

			default:
				$output .= "<ExecuteItem URI=\"".$Server."?user=".$user."\"/>\n";
				break;
			}
		$output .= "</AastraIPPhoneExecute>\n";
		}

	if($action=="set")
		{
		$res = $as->Command('database put CF '.$user.' '.$value);
		$output = "<AastraIPPhoneExecute>\n";
		$output .= "<ExecuteItem URI=\"".$Server."?action=msg&amp;user=".$user."\"/>\n";
		switch($header[0])
			{
			case "Aastra9112i":
			case "Aastra9133i":
				break;

			default:
				$output .= "<ExecuteItem URI=\"".$Server."?user=".$user."\"/>\n";
				break;
			}
		$output .= "</AastraIPPhoneExecute>\n";
		}

	if($action=="change") 
		{
		$output = "<AastraIPPhoneInputScreen type=\"number\" destroyOnExit=\"yes\">\n";
		$output .= "<Title>Call Forward</Title>\n";
		$output .= "<Prompt>Enter destination</Prompt>\n";
		$output .= "<URL>".$Server."?user=$user&amp;action=set</URL>\n";
		$output .= "<Parameter>value</Parameter>\n";
		$output .= "<Default></Default>\n";
		$output .= "</AastraIPPhoneInputScreen>\n";
		}

	if($action=="msg") 
		{
		$output = "<AastraIPPhoneStatus Beep=\"yes\">\n";
		$output .= "<Session>CFDND</Session>\n";
		if ($cf=="") $output .= "<Message index=\"1\"></Message>\n";
		else $output .= "<Message index=\"1\">CFWD activated</Message>\n";
		$output .= "</AastraIPPhoneStatus>\n";
		}

	# Disconnect properly	
	$as->disconnect();

	header("Content-Type: text/xml");
	header("Content-Length: ".strlen($output));
	echo $output;
	exit;
	}

# Disconnect properly	
$as->disconnect();

# Setup header type
header("Content-Type: text/xml");

switch($header[0])
	{
	case "Aastra9112i":
	case "Aastra9133i":
		$output = "<AastraIPPhoneTextMenu destroyOnExit=\"yes\">\n";
		if($cf=="") $output .= "<Title>CFWD deactivated</Title>\n";
		else $output .= "<Title>CFWD set (".$cf.")</Title>\n";
		if($cf!="")
			{
			$output .= "<MenuItem>\n";
			$output .= "<Prompt>Cancel</Prompt>\n";
	  		$output .= "<URI>$Server/cfwd.php?action=cancel&amp;user=$user</URI>\n";
	  		$output .= "</MenuItem>\n";	
			}
		$output .= "<MenuItem>\n";
		$output .= "<Prompt>Change</Prompt>\n";
  		$output .= "<URI>$Server/cfwd.php?action=change&amp;user=$user</URI>\n";
  		$output .= "</MenuItem>\n";	
		$output .= "</AastraIPPhoneTextMenu>\n";
		break;

	default:
		$output = "<AastraIPPhoneTextScreen destroyOnExit=\"yes\">\n";
		$output .= "<Title>Call Forward for $user</Title>\n";
		if ($cf=="") $output .= "<Text>Call Forward is currently deactivated.</Text>\n";
		else $output .= "<Text>Call Forward is currently set to $cf.</Text>\n";
		$output .= "<SoftKey index=\"1\">\n";
		$output .= "<Label>Change</Label>\n";
		$output .= "<URI>$Server/cfwd.php?action=change&amp;user=$user</URI>\n";
		$output .= "</SoftKey>\n";
		if($cf!="")
			{
			$output .= "<SoftKey index=\"2\">\n";
			$output .= "<Label>Cancel</Label>\n";
			$output .= "<URI>$Server/cfwd.php?action=cancel&amp;user=$user</URI>\n";
			$output .= "</SoftKey>\n";
			}
		$output .= "<SoftKey index=\"6\">\n";
		$output .= "<Label>Done</Label>\n";
		$output .= "<URI>SoftKey:Exit</URI>\n";
		$output .= "</SoftKey>\n";
		$output .= "</AastraIPPhoneTextScreen>\n";
		break;
	}

header("Content-Length: ".strlen($output));
echo $output;
?>
